local player = ...
local pn = tonumber(player:sub(-1))

local percent = WF.ITGScore[pn]

if WF.ECFAMatch == "FA+" then
	-- hijack the score text to just give the adjusted FA+ score here
	local pss = STATSMAN:GetCurStageStats():GetPlayerStageStats(player)
	local notes = pss:GetRadarPossible():GetValue("RadarCategory_TapsAndHolds")
	local tholdsrolls = pss:GetRadarPossible():GetValue("RadarCategory_Holds") + pss:GetRadarPossible():GetValue("RadarCategory_Rolls")
	local pholdsrolls = pss:GetRadarActual():GetValue("RadarCategory_Holds") + pss:GetRadarActual():GetValue("RadarCategory_Rolls")
	local subtract = (pss:GetTapNoteScores("TapNoteScore_HitMine") + pss:GetTapNoteScores("TapNoteScore_Miss")
		+ (tholdsrolls - pholdsrolls))
	local points = 2*WF.FAPlusCount[pn][2] - subtract
	percent = (notes > 0) and string.format("%0.2f", math.floor(10000*(points/(2*notes)))/100) or "0.00"
end

return Def.ActorFrame{
	Name="PercentageContainer"..ToEnumShortString(player),
	OnCommand=function(self)
		self:y( _screen.cy-26 )
	end,

	-- dark background quad behind player percent score
	Def.Quad{
		InitCommand=function(self)
			self:diffuse(color("#101519")):zoomto(158.5, 60)
			self:horizalign(player==PLAYER_1 and left or right)
			self:x(150 * (player == PLAYER_1 and -1 or 1))
		end
	},

	LoadFont("_wendy white")..{
		Name="Percent",
		Text=percent,
		InitCommand=function(self)
			self:horizalign(right):zoom(0.585)
			self:x( (player == PLAYER_1 and 1.5 or 141))
			if WF.ECFAMatch == "FA+" then
				self:diffuse(SL.JudgmentColors.ITG[1])
			end
		end
	}
}
